/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindow;
import controlP5.ControllerGroup;
import processing.core.PApplet;

public class Tab
extends ControllerGroup {
    int _myOffsetX = -1000;
    int _myOffsetY = -1000;
    boolean isActive = false;
    boolean isEventActive = false;
    float _myValue = 0.0f;
    String _myStringValue = "";

    public Tab(ControlP5 controlP5, ControlWindow controlWindow, String string) {
        super(controlP5, null, string, 0.0f, 0.0f);
        this._myControlWindow = controlWindow;
        this.position = new CVector3f();
        this.positionBuffer = new CVector3f();
        this.absolutePosition = new CVector3f();
        this.isMoveable = false;
        this.isEventActive = controlP5.isTabEventsActive;
    }

    protected void setOffset(int n, int n2) {
        this._myOffsetX = n;
        this._myOffsetY = n2;
    }

    protected void drawLabel(PApplet pApplet) {
        this.isInside = this.inside();
        if (this._myControlWindow.tabs().size() > 2) {
            pApplet.pushMatrix();
            pApplet.fill(this.isInside ? this.color.colorForeground : this.color.colorBackground);
            if (this.isActive) {
                pApplet.fill(this.color.colorActive);
            }
            pApplet.rect((float)this._myOffsetX, (float)this._myOffsetY, (float)(this._myLabel.width() - 1), 16.0f);
            this._myLabel.draw(pApplet, this._myOffsetX + 4, this._myOffsetY + 5);
            pApplet.popMatrix();
        }
    }

    protected int width() {
        return this._myLabel.width();
    }

    protected boolean inside() {
        return this._myControlWindow.mouseX > this._myOffsetX && this._myControlWindow.mouseX < this._myOffsetX + this._myLabel.width() && this._myControlWindow.mouseY > this._myOffsetY && this._myControlWindow.mouseY < this._myOffsetY + 16;
    }

    public void mousePressed() {
        this._myControlWindow.activateTab(this);
        if (this.isEventActive) {
            this.controlP5.controlbroadcaster().broadcast(new ControlEvent(this), 0);
        }
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    protected boolean isActive() {
        return this.isActive;
    }

    public void moveTo(ControlWindow controlWindow) {
        this._myControlWindow.removeTab(this);
        this.setTab(controlWindow, this.name());
    }

    public Tab activateEvent(boolean bl) {
        this.isEventActive = bl;
        return this;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setName("tab");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("id", new Integer(this.id()));
        controlP5XMLElement.removeAttribute("x");
        controlP5XMLElement.removeAttribute("y");
    }

    public String stringValue() {
        return this._myStringValue;
    }

    public float value() {
        return this._myValue;
    }

    public void setValue(float f) {
        this._myValue = f;
    }

    public void setStringValue(String string) {
        this._myStringValue = string;
    }
}

